function detectAIMetatags() {
  const elements = document.querySelectorAll('[data-ai-generated], [data-ai-enhanced], [data-ai-free]');
  let detected = false;

  elements.forEach(element => {
    detected = true;
    element.classList.add('ai-content-detected');
    
    const badge = document.createElement('div');
    badge.className = 'ai-content-badge';
    badge.textContent = 'AI';
    element.appendChild(badge);
  });

  chrome.runtime.sendMessage({aiContentDetected: detected});
}

detectAIMetatags();
